﻿var assignmentselection = {
    context: $(".v-CallbackAssignmentModifySelection"),
    initialize: function () {
        a4.initializeInputs(this.context);
        this.updateConfirmButtonState();
        
        //if ($("#ModificationType", this.context).val() != "SingleCase")
        //    $("#PriorityValue", this.context).attr("disabled", "disabled").prop("disabled", true);

        $(".h-assignmentSelectionInterviewers-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetCaseFilterInterviewersForAutoComplete", "CallBacks", { isCallback: true }),
            multipleSelection: $("#ModificationType", this.context).val() != "SingleCase",
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#InterviewerIds"),
            altValueSeperator: '|'
        });
    },
    bindEvents: function () {
        $("input, select", this.context).on("change", function () {
            assignmentselection.updateConfirmButtonState();
        });

        $("#submit1").on("click", function () {
            if ($("#ModificationType", this.context).val() != "SingleCase")
                assignmentselection.saveMultipleCallback();
            else
                assignmentselection.saveSingleCallback();
        });

        $("#PriorityType", this.context).on("change", function () {
            var value = $(this).find(":selected").val();
            $(".v-priorityValueSection", this.context).toggle(value != "");
        });      
    },

    updateConfirmButtonState: function(){
        var disableConfirmButton = this.getChangeItems().length < 1;
        assignmentselection.toggleConfirmButton(disableConfirmButton);
    },

    saveSingleCallback: function () {
        assignmentselection.toggleConfirmButton(true);
        return assignmentselection.saveChanges();
    },
    saveMultipleCallback: function () {
        var itemChanges = this.getChangeItems();
        if ($("#ModificationType", this.context).val() == "All") {
            var selectedRowsCount = a4.parent().assignments.totalRecords;
        }
        else {
            var selectedRowsCount = a4.parent().assignments.datatable.a4datatable("getSelectedItems").length;
        }
        assignmentselection.toggleConfirmButton(true);
        modalDialog.showConfirmDialog(confirmCallbackAssignmentResources, function () {
            return assignmentselection.saveChanges();
        }, 200 + (itemChanges.length * 20), 550, false, { "items": itemChanges.join("<br/>"), "editCount": selectedRowsCount }, { "cancel": function () { assignmentselection.toggleConfirmButton(false);} });
    },
    saveChanges: function () {
        $.when(a4.parent().assignments.applySelection($("#InterviewerIds").val(), $("#ChangeDate").val(), $("#ChangeTime").val(), $("#ProjectId").val(), $("#ModificationType").val(), $("#PriorityValue").val(), $("#PriorityType").val(), $("#TimeSlotStatus").val(), $("#DialingMode").val(), $("#CyclePhoneNumber").val(), a4.parent().assignments.caseFilter))
        .then(function () { modalDialog.close(); });
    },
    getChangeItems: function () {
        var itemChange = [];

        if ($("#InterviewerIds").val() != "")
            itemChange.push(resources.BelongingTo);
        if ($("#ChangeDate").val() != "")
            itemChange.push(resources.ChangeDate);
        if ($("#ChangeTime").val() != "")
            itemChange.push(resources.ChangeTime);
        if ($("#PriorityType option:selected").val() != "")
            itemChange.push(resources.Priority);
        if ($("#TimeSlotStatus option:selected").val() != "")
            itemChange.push(resources.TimeSlotStatus);
        if ($("#DialingMode option:selected").val() != "")
            itemChange.push(resources.DialingMode);
        if ($("#CyclePhoneNumber option:selected").val() != "")
            itemChange.push(resources.CyclePhoneNumber);

        return itemChange;
    },
    toggleConfirmButton: function (disabled) {
        $("#submit1").prop('disabled', disabled);
    }
};

$(document).ready(function () {
    if (assignmentselection.context.length > 0) {
        assignmentselection.initialize();
        assignmentselection.bindEvents();
    }
});